//
//  YHGrabFileCell.swift
//  galaxy
//
//  Created by edy on 2024/8/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHGrabFileCell: UICollectionViewCell {
    
    static let cellReuseIdentifier = "YHGrabFileCell"

    lazy var fileImgView: UIImageView = {
        let view = UIImageView(image: UIImage(named: "global_default_image"))
        view.contentMode = .scaleAspectFit
        return view
    }()
    
    var fileUrl: String = "" {
        didSet {
            if let url = URL(string: fileUrl) {
                fileImgView.sd_setImage(with: url, placeholderImage: UIImage(named: "global_default_image"))
            } else {
                fileImgView.image = UIImage(named: "global_default_image")
            }
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        
        self.layer.cornerRadius = 5.0
        self.layer.borderWidth = 1.0
        self.layer.borderColor = UIColor.init(hex: 0xD8D8D8).cgColor
        self.clipsToBounds = true
        self.addSubview(fileImgView)
        fileImgView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
    }

}
